/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public abstract class ByteUtilities {
    private static final String ZEROS = "0000000000000000";

    public static final byte[] byteCopy(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4;
        int n5;
        if (byArray2 == null || byArray2.length < n2 || byArray2.length - n2 < n3) {
            return null;
        }
        if (byArray == null) {
            byArray = new byte[n];
        }
        if ((n5 = (n4 = n + n3)) < byArray.length) {
            n5 = byArray.length;
        }
        byte[] byArray3 = new byte[n5];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray2, n2, byArray3, n, n3);
        if (n5 > n4) {
            System.arraycopy(byArray, n4, byArray3, n4, byArray.length - n4);
        }
        return byArray3;
    }

    public static final byte[] byteCopy(byte[] byArray, byte[] byArray2) {
        if (byArray2 == null) {
            return ByteUtilities.byteCopy(byArray, 0, byArray2, 0, 0);
        }
        return ByteUtilities.byteCopy(byArray, 0, byArray2, 0, byArray2.length);
    }

    public static final byte[] byteCat(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (byArray == null) {
            return ByteUtilities.byteCopy(byArray, 0, byArray2, n, n2);
        }
        return ByteUtilities.byteCopy(byArray, byArray.length, byArray2, n, n2);
    }

    public static final byte[] byteCat(byte[] byArray, byte[] byArray2) {
        int n = 0;
        int n2 = 0;
        if (byArray2 != null) {
            n2 = byArray2.length;
        }
        if (byArray != null) {
            n = byArray.length;
        }
        return ByteUtilities.byteCopy(byArray, n, byArray2, 0, n2);
    }

    public static final byte[] byteCopyAndTrim(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray2 != null && (byArray2.length < n2 || byArray2.length - n2 < n3)) {
            return null;
        }
        if (byArray2 == null) {
            return null;
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        byte[] byArray3 = new byte[n + n3];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        if (n3 > 0) {
            System.arraycopy(byArray2, n2, byArray3, n, n3);
        }
        return byArray3;
    }

    public static final byte[] byteCopyAndTrim(byte[] byArray, int n, byte[] byArray2) {
        if (byArray2 == null) {
            return ByteUtilities.byteCopyAndTrim(byArray, n, byArray2, 0, 0);
        }
        return ByteUtilities.byteCopyAndTrim(byArray, n, byArray2, 0, byArray2.length);
    }

    public static final byte[] byteTrim(byte[] byArray, int n) {
        return ByteUtilities.byteCopyAndTrim(byArray, n, null, 0, 0);
    }

    public static final byte[] byteInsert(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4;
        if (byArray2 == null || byArray2.length < n2 || byArray2.length - n2 < n3) {
            return null;
        }
        byte[] byArray3 = new byte[byArray.length + n3];
        for (n4 = 0; n4 < n; ++n4) {
            byArray3[n4] = byArray[n4];
        }
        for (n4 = 0; n4 < n3; ++n4) {
            byArray3[n4 + n] = byArray2[n4 + n2];
        }
        for (n4 = n; n4 < byArray.length; ++n4) {
            byArray3[n4 + n3] = byArray[n4];
        }
        return byArray3;
    }

    public static final String toHexString(Number number, int n) {
        if (n < 1) {
            return "";
        }
        if (n > 16) {
            n = 16;
        }
        StringBuffer stringBuffer = new StringBuffer(Long.toHexString(number.longValue()).toUpperCase());
        stringBuffer.insert(0, ZEROS.substring(0, n - stringBuffer.length()));
        return stringBuffer.toString();
    }

    public static final String toHexString(UnsignedInt16 unsignedInt16) {
        return ByteUtilities.toHexString((Number)unsignedInt16, 4);
    }

    public static final String toHexString(UnsignedInt16[] unsignedInt16Array) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < unsignedInt16Array.length; ++i) {
            stringBuffer.append(ByteUtilities.toHexString(unsignedInt16Array[i]));
        }
        return stringBuffer.toString();
    }

    public static final String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(ByteUtilities.toHexString(new Integer(byArray[i] & 0xFF), 2));
        }
        return stringBuffer.toString();
    }

    public static final byte[] hexStringToByteArray(String string) throws NumberFormatException {
        if (string.length() % 2 != 0) {
            throw new NumberFormatException("Hexstring length cannot be odd");
        }
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)Short.parseShort(string.substring(i * 2, i * 2 + 2), 16);
        }
        return byArray;
    }

    public static final byte[] integerVectorOfShortsToBytes(Vector vector) {
        byte[] byArray = new byte[vector.size() * 2];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            int n2 = (Integer)enumeration.nextElement();
            byArray[n * 2] = (byte)((n2 & 0xFF00) >> 8);
            byArray[n * 2 + 1] = (byte)(n2 & 0xFF);
            ++n;
        }
        return byArray;
    }

    public static final String integerVectorOfShortsToString(Vector vector) {
        return ByteUtilities.integerVectorOfShortsToString(vector, ",");
    }

    public static final String integerVectorOfShortsToString(Vector vector, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append((Integer)enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static final Vector stringToIntegerVectorOfShorts(String string, int n) throws NumberFormatException {
        return ByteUtilities.stringToIntegerVectorOfShorts(string, n, ",");
    }

    public static final Vector stringToIntegerVectorOfShorts(String string, int n, String string2) throws NumberFormatException {
        Vector<Integer> vector = new Vector<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        if (stringTokenizer.countTokens() > n) {
            throw new NumberFormatException("Too many entries");
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if ("".equals(string3)) continue;
            Integer n2 = Integer.decode(string3);
            if (n2 < 0 || n2 > 65535) {
                throw new NumberFormatException("Short value out of range");
            }
            vector.add(n2);
        }
        return vector;
    }

    public static final short byteArrayToShort(byte[] byArray) {
        return ByteUtilities.byteArrayToShort(byArray, 0);
    }

    public static final short byteArrayToShort(byte[] byArray, int n) {
        return (short)(byArray[n] << 8 & 0xFF00 | byArray[n + 1] & 0xFF);
    }

    public static final int byteArrayToInt(byte[] byArray) {
        return ByteUtilities.byteArrayToInt(byArray, 0);
    }

    public static final int byteArrayToInt(byte[] byArray, int n) {
        return byArray[n] << 24 & 0xFF000000 | byArray[n + 1] << 16 & 0xFF0000 | byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] & 0xFF;
    }

    public static final long byteArrayToLong(byte[] byArray, int n) {
        return (long)(byArray[n] << 56) & 0xFF00000000000000L | (long)(byArray[n + 1] << 48) & 0xFF000000000000L | (long)(byArray[n + 2] << 40) & 0xFF0000000000L | (long)(byArray[n + 3] << 32) & 0xFF00000000L | (long)(byArray[n + 4] << 24 & 0xFF000000) | (long)(byArray[n + 5] << 16 & 0xFF0000) | (long)(byArray[n + 6] << 8 & 0xFF00) | (long)(byArray[n + 7] & 0xFF);
    }

    public static final void shortToByteArray(byte[] byArray, int n, short s) {
        byArray[n] = (byte)(s >> 8 & 0xFF);
        byArray[n + 1] = (byte)(s & 0xFF);
    }

    public static final byte[] shortToByteArray(short s) {
        byte[] byArray = new byte[]{(byte)(s >> 8 & 0xFF), (byte)(s & 0xFF)};
        return byArray;
    }

    public static final void intToByteArray(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 24 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 & 0xFF);
    }

    public static final byte[] intToByteArray(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    public static final BitSet byteArrayToBitSet(byte[] byArray) {
        BitSet bitSet = new BitSet(byArray.length * 8);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            int n = 0;
            while (n < 8) {
                if ((by & 1) == 1) {
                    bitSet.set((byArray.length - i - 1) * 8 + n);
                }
                ++n;
                by = (byte)(by >> 1);
            }
        }
        return bitSet;
    }

    public static final byte[] bitSetToByteArray(BitSet bitSet) {
        int n = bitSet.size() / 8;
        if (bitSet.size() % 8 != 0) {
            --n;
        }
        return ByteUtilities.bitSetToByteArray(bitSet, n);
    }

    public static final byte[] bitSetToByteArray(BitSet bitSet, int n) {
        return ByteUtilities.bitSetToByteArray(bitSet, 0, n);
    }

    public static final byte[] bitSetToByteArray(BitSet bitSet, int n, int n2) {
        byte[] byArray = new byte[n2];
        for (int i = n; i < n + n2; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (!bitSet.get((n2 - 1 - i) * 8 + j)) continue;
                int n3 = i;
                byArray[n3] = (byte)(byArray[n3] | 1 << j);
            }
        }
        return byArray;
    }

    public static final UnsignedInt16 bitSetToUnsignedInt16(BitSet bitSet) {
        byte[] byArray = ByteUtilities.bitSetToByteArray(bitSet, 2);
        short s = ByteUtilities.byteArrayToShort(byArray);
        return new UnsignedInt16((int)s);
    }

    public static final UnsignedInt16 bitSetToUnsignedInt16(BitSet bitSet, int n) {
        byte[] byArray = ByteUtilities.bitSetToByteArray(bitSet, n, 2);
        short s = ByteUtilities.byteArrayToShort(byArray);
        return new UnsignedInt16((int)s);
    }

    public static final UnsignedInt32 bitSetToUnsignedInt32(BitSet bitSet) {
        byte[] byArray = ByteUtilities.bitSetToByteArray(bitSet, 4);
        int n = ByteUtilities.byteArrayToInt(byArray);
        return new UnsignedInt32((long)n);
    }

    public static final UnsignedInt32 bitSetToUnsignedInt32(BitSet bitSet, int n) {
        byte[] byArray = ByteUtilities.bitSetToByteArray(bitSet, n, 4);
        int n2 = ByteUtilities.byteArrayToInt(byArray);
        return new UnsignedInt32((long)n2);
    }

    public static final Vector bitSetToUnsignedInt8Vec(BitSet bitSet) {
        int n = bitSet.size() / 8;
        if (bitSet.size() % 8 != 0) {
            --n;
        }
        return ByteUtilities.bitSetToUnsignedInt8Vec(bitSet, n);
    }

    public static final Vector bitSetToUnsignedInt8Vec(BitSet bitSet, int n) {
        return ByteUtilities.bitSetToUnsignedInt8Vec(bitSet, 0, n);
    }

    public static final Vector bitSetToUnsignedInt8Vec(BitSet bitSet, int n, int n2) {
        Vector<UnsignedInt8> vector = new Vector<UnsignedInt8>();
        vector.setSize(n2);
        for (int i = n; i < n + n2; ++i) {
            int n3 = 0;
            for (int j = 0; j < 8; ++j) {
                if (!bitSet.get((n2 - 1 - i) * 8 + j)) continue;
                n3 |= 1 << j;
            }
            vector.setElementAt(new UnsignedInt8((short)n3), i);
        }
        return vector;
    }

    public static final BitSet unsignedInt8VecToBitSet(Vector vector) {
        BitSet bitSet = new BitSet(vector.size() * 8);
        for (int i = 0; i < vector.size(); ++i) {
            byte by = (byte)((UnsignedInt8)vector.elementAt(i)).shortValue();
            int n = 0;
            while (n < 8) {
                if ((by & 1) == 1) {
                    bitSet.set((vector.size() - i - 1) * 8 + n);
                }
                ++n;
                by = (byte)(by >> 1);
            }
        }
        return bitSet;
    }

    public static String getBitsFromByte(int n) {
        if (n < 0 || n > 255) {
            System.out.println("Warning: getBitsFromByte() only accepts value between 0 and 255!");
            return new String("");
        }
        int n2 = 128;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i <= 8; ++i) {
            stringBuffer.append((n & n2) == 0 ? (char)'0' : '1');
            n <<= 1;
        }
        return stringBuffer.toString();
    }

    public static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }
}

